package edu.uky.ai.lp.gui;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class ConsoleInput extends Reader {

	private final BlockingQueue<char[]> queue = new LinkedBlockingQueue<>();
	private char[] first = null;
	
	void write(String string) {
		try {
			queue.put(string.toCharArray());
		}
		catch(InterruptedException ex) {
			ex.printStackTrace();
		}
	}
	
	@Override
	public int read(char[] cbuf, int off, int len) throws IOException {
		if(first == null || first.length == 0) {
			try {
				first = queue.take();
			}
			catch(InterruptedException ex) {
				return 0;
			}
		}
		int read = Math.min(first.length, len);
		System.arraycopy(first, 0, cbuf, off, read);
		first = Arrays.copyOf(first, first.length - read);
		return read;
	}

	@Override
	public void close() throws IOException {
		// do nothing
	}
}
